# PL0 Scanner

# Initialize the scanner by opening the input source file.
def scannerInitialize (fname):
    global fp
    try:
      fp = open (fname, "r")
    except:
        print ("No such file. ");
        exit()
    print ("File "+fname+" is open.")
    
# Return the next character in teh input stream
def nextCh ():
    global ch,eof
    
    keywords["CONST"] = constSy
    keywords["VAR"] = varSy
    keywords["FUNCTION"] = functionSy
    keywords["BEGIN"] = beginSy
    keywords["END"] = endSy
    keywords["IF"] = ifSy
    keywords["THEN"] = thenSy
    keywords["WHILE"] = whileSy
    keywords["DO"] = doSy
    keywords["CALL"] = returnSy
    keywords["WRITE"] = writeSy
    keywords["ODD"] = oddSy
    keywords["CALL"] = callSy   
    if len(ch)==0: return eof
    try:
        ch = fp.read(1)
        return ch[0]
    except IOError:
      print('An error occured trying to read the file.')    
    except ValueError:
      print('Non-numeric data found in the file.')
    except ImportError:
      print ("NO module found")    
    except EOFError:
      print('Why did you do an EOF on me?')
      return eof
    except KeyboardInterrupt:
      print('You cancelled the operation.')
    except:
      print('An error occured.')
    return ch

def nextSy ():
    global ch, sy, ident, numberVal, keywords
    if len(ch) <= 0: return finalSy
    
    if ch == " " or ch == "\n":
        while ch == " " or ch == "\n": nextCh()
        
    if letter(ch):
        scanIdent()
        try:
            k = keywords[ident]
            return k
        except:
            return identSy
        
    if digit(ch):
        scanNumber()
        return numberSy
    if ch == "+":
        nextCh()
        if digit(ch):
            scanNumber()
            return numberSy
        else:
            return plusSy
    elif ch == "-":
        nextCh()
        if digit(ch):
            scanNumber()
            numberVal = -numberVal
            return numberSy
        else:
            return minusSy
        
    elif ch == "*":
        nextCh()
        return multSy
    elif ch == "/":
        nextCh()
        return divideSy
    elif ch == "=":
        nextCh()
        return equalSy
    elif ch == "<":
        nextCh()
        if ch == "=":
            nextCh()
            return lesseqSy
        elif ch == ">":
            return noteqSy
        else:
            return lessSy
    elif ch == ">":
        nextCh()
        if ch == "=":
            nextCh()
            return greatereqSy
        else:
            return greaterSy
    elif ch == "(":
        nextCh ()
        return lparenSy
    elif ch == ")":
        nextCh()
        return rparenSy
    
    elif ch == ":":
        nextCh()
        if ch == "=":
            nextCh()
            return assignSy
        else:
            return errorSy
    
    elif ch == ";":
        nextCh()
        return semiSy
    elif ch == ",":
        nextCh()
        return commaSy
    elif ch == ".":
        nextCh()
        return periodSy
    elif ch == "!":
        nextCh()
        return bangSy
    elif ch == "?":
        nextCh()
        return questSy
    else:
        return finalSy
    
def digit (c):
    if c>="0" and c<="9": return True
    return False

def digitVal (c):
    return ord(c) - ord("0")

def letter (c):
    if c>="A" and c<="Z": return True
    if c>="a" and c<="z": return True
    return False

def identChar(c):
    if c>="0" and c<="9": return True
    if c>="A" and c<="Z": return True
    if c>="a" and c<="z": return True
    if c == "_": return True
    return False
    
def scanNumber():
    global numberVal
    numberVal = 0
    while digit(ch):
        numberVal = numberVal*10 + digitVal(ch)
        nextCh()
        
def scanIdent ():
    global ident
    ident = ""
    while identChar(ch):
        ident = ident + ch
        nextCh()

def outSy (ss):
    if ss == numberSy:
        return "Number "+str(numberVal)
    if ss == plusSy: return " + "

    if ss == minusSy: return " - "
    if ss == multSy: return " * "
    if ss == divideSy: return " / "
    if ss == equalSy: return " = "
    if ss == lesseqSy: return " <= "
    if ss == noteqSy: return " <> "
    if ss == lessSy: return " < "
    if ss == greatereqSy: return " >= "
    if ss == greaterSy: return " > "
    if ss == lparenSy: return " ( "
    if ss == rparenSy: return " ) "
    if ss == semiSy: return " ; "
    if ss == commaSy: return " , "
    if ss == periodSy: return " . "
    
    if ss == identSy: return " Identifier "+ident
    if ss == bangSy: return " ! "
    if ss == questSy: return " ? "
    if ss == constSy: return " CONST "
    if ss == varSy: return " VAR "
    if ss == functionSy: return " PROCEDURE "
    if ss == beginSy: return " BEGIN "
    if ss == endSy: return " END "
    if ss == ifSy: return " IF "
    if ss == thenSy: return " THEN "
    if ss == whileSy: return " WHILE "
    if ss == doSy: return " DO "
    if ss == returnSy: return " RETURN "
    if ss == writeSy: return " WRITE "
    if ss == oddSy: return " ODD "
    if ss == callSy: return " CALL "
    if ss == finalSy: return " <FINAL> "
    if ss == noSy: return " <NONE> "
    if ss == errorSy: return " <Error> "
    if ss == assignSy: return " := "
    
